package ru.yandex.search.disk.proxy;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ProxyConfigBuilder
    extends AbstractProxyConfigBuilder<ProxyConfigBuilder>
{
    public ProxyConfigBuilder() {
        super(ProxyConfigDefaults.INSTANCE);
    }

    public ProxyConfigBuilder(final ProxyConfig config) {
        super(config);
    }

    public ProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ProxyConfigDefaults.INSTANCE);
    }

    public ProxyConfigBuilder(
        final IniConfig config,
        final ProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ProxyConfigBuilder self() {
        return this;
    }

    public ImmutableProxyConfig build() throws ConfigException {
        return new ImmutableProxyConfig(this);
    }
}

