package ru.yandex.search.disk.proxy;

import java.util.Collections;
import java.util.Set;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.erratum.ErratumConfig;
import ru.yandex.geocoder.GeocoderConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigDefaults;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class ProxyConfigDefaults
    extends UniversalSearchProxyConfigDefaults
    implements ProxyConfig
{
    public static final ProxyConfigDefaults INSTANCE =
        new ProxyConfigDefaults();

    private static final long DEFAULT_FAT_USER_DOCS = 100000;

    protected ProxyConfigDefaults() {
    }

    @Override
    public String name() {
        return "Proxy";
    }

    @Override
    public ErratumConfig misspellConfig() {
        return null;
    }

    @Override
    public GeocoderConfig geoSearchConfig() {
        return null;
    }

    @Override
    public HttpHostConfig userSplitConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String imagesFilter() {
        return null;
    }

    @Override
    public String searchPostFilter() {
        return "";
    }

    @Override
    public String diskService() {
        return "disk_queue";
    }

    @Override
    public String photosliceService() {
        return diskService();
    }

    @Override
    public String ipddService() {
        return "ipdd";
    }

    @Override
    public Set<String> producerServices() {
        return Collections.emptySet();
    }

    @Override
    public long fatUserDocs() {
        return DEFAULT_FAT_USER_DOCS;
    }

    @Override
    public HttpTargetConfig photosliceClientConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public JniWrapperConfig dssmConfig() {
        return JniWrapperConfigDefaults.INSTANCE;
    }

    @Override
    public long dssmThreshold() {
        return 0L;
    }

    @Override
    public URIConfig djfsConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public Long failoverSearchDelay() {
        return null;
    }

    @Override
    public String djfsTvmClientId() {
        return null;
    }

    @Override
    public String geoTvmClientId() {
        return null;
    }

    @Override
    public HttpHostConfig faceIndexerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }
}

