package ru.yandex.search.disk.proxy;

import java.util.concurrent.ThreadLocalRandom;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixType;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class RandomPhotoHandler implements ProxyRequestHandler {
    private final Proxy proxy;
    private final String serviceName;
    private final PrefixType prefixType;

    public RandomPhotoHandler(final Proxy proxy) {
        this.proxy = proxy;
        serviceName = proxy.diskService();
        prefixType = proxy.searchMap().prefixType(serviceName);
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        Prefix prefix = session.params().get("uid", prefixType);
        AsyncClient client = proxy.searchClient().adjust(session.context());
        UniversalSearchProxyRequestContext requestContext =
            new PlainUniversalSearchProxyRequestContext(
                new User(serviceName, prefix),
                null,
                true,
                client,
                session.logger());
        StringBuilder filter = new StringBuilder(
            "/search?json-type=dollar&IO_PRIO=0&length=1000&get=latitude,"
            + "longitude,etime,key,stid,resource_id&sort=beautiful"
            + PhotosDateRangeHandler.FILTER);
        if (session.params().getBoolean("require-coords", false)) {
            filter.append(PhotosDateRangeHandler.COORDS_FILTER);
        }
        QueryConstructor query = new QueryConstructor(filter);
        query.append("prefix", prefix.toString());
        query.append("service", serviceName);
        proxy.parallelRequest(
            session,
            requestContext,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            session.listener().createContextGeneratorFor(client),
            new Callback(
                session,
                JsonTypeExtractor.NORMAL.extract(session.params())));
    }

    private static class Callback
        extends AbstractProxySessionCallback<JsonObject>
    {
        private final JsonType jsonType;

        Callback(final ProxySession session, final JsonType jsonType) {
            super(session);
            this.jsonType = jsonType;
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                JsonList docs = result.get("hitsArray").asList();
                JsonObject doc;
                if (docs.isEmpty()) {
                    doc = null;
                } else {
                    doc = docs.get(
                        ThreadLocalRandom.current().nextInt(0, docs.size()));
                }
                if (doc == null) {
                    session.response(HttpStatus.SC_NOT_FOUND);
                } else {
                    session.response(
                        HttpStatus.SC_OK,
                        new NStringEntity(
                            jsonType.toString(doc),
                            ContentType.APPLICATION_JSON
                                .withCharset(session.acceptedCharset())));
                }
            } catch (JsonException e) {
                failed(e);
            }
        }
    }
}

