package ru.yandex.search.disk.proxy;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.searchmap.User;

public class SearchMapHostsResolver implements ProxyRequestHandler {
    private final ProxyHandler handler;
    private final SearchMap searchMap;

    public SearchMapHostsResolver(
        final ProxyHandler handler,
        final SearchMap searchMap)
    {
        this.handler = handler;
        this.searchMap = searchMap;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        User user = handler.user(session);
        List<HttpHost> hosts = searchMap.searchHosts(user);
        session.logger().info("Hosts for user " + user + " are " + hosts);
        if (hosts.isEmpty()) {
            throw new NotFoundException("Don't know where the user " + user);
        }
        handler.handle(session, user, Proxy.shuffle(hosts, user));
    }

    @Override
    public String toString() {
        return handler.toString();
    }
}

