package ru.yandex.search.disk.proxy;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;

import ru.yandex.function.EmptySupplier;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.ErrorSuppressingFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.RequestErrorType;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.searchmap.User;

public class WarmupHandler extends AbstractUidProxyHandler {
    private static final Function<Exception, RequestErrorType> ERROR_CLASSIFIER
        = (e) -> {
            RequestErrorType errorType =
                RequestErrorType.ERROR_CLASSIFIER.apply(e);
            if (errorType == RequestErrorType.HOST_NON_RETRIABLE) {
                errorType = RequestErrorType.IO;
            }
            return errorType;
        };

    public WarmupHandler(
        final Proxy proxy,
        final Collection<Warmable> warmables)
        throws HttpException
    {
        super(proxy, proxy.diskService());
    }

    @Override
    public void handle(
        final ProxySession session,
        final User user,
        final List<HttpHost> hosts)
        throws HttpException
    {
        final MultiFutureCallback<Object> mfCallback =
            new MultiFutureCallback<>(new WarmupCallback(session));
        final AsyncClient client =
            proxy.searchClient().adjust(session.context());

        StringBuilder baseUri = new StringBuilder("/search-warmup");
        baseUri.append("?");
        baseUri.append("&get=id,parent_fid,name");
        baseUri.append("&update-prefix-activity=true");
        baseUri.append("&prefix=");
        baseUri.append(user.prefix());
        baseUri.append("&service=");
        baseUri.append(user.service());
        baseUri.append("&text=(type:file+AND+(has_i2t:1+OR+name_tokenized:*)"
            + "+AND+aux_folder:(%22disk%22+%22photounlim%22))+AND+NOT"
            + "+(aux_folder:photounlim+AND+ext:(mkv+avi))");
        baseUri.append("&sort=mtime&length=200");
        baseUri.append("&IO_PRIO=10000");

        for (HttpHost host : hosts) {
            client.execute(
                host,
                new BasicAsyncRequestProducerGenerator(baseUri.toString()),
                EmptyAsyncConsumerFactory.INSTANCE,
                session.listener().createContextGeneratorFor(
                    client),
                new ErrorSuppressingFutureCallback<Object>(
                    mfCallback.newCallback(),
                    ERROR_CLASSIFIER,
                    EmptySupplier.INSTANCE));
        }

        mfCallback.done();
    }

    private static final class WarmupCallback
        extends AbstractProxySessionCallback<Object>
    {
        private WarmupCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
