package ru.yandex.search.disk.proxy.face;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.StatusCodeAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.disk.proxy.Proxy;

public class FaceReindexHandler implements ProxyRequestHandler {
    private final AsyncClient client;

    private final ImmutableHttpHostConfig faceHostConfig;

    public FaceReindexHandler(final Proxy proxy) throws IOException{
        faceHostConfig = proxy.config().faceIndexerConfig();
        if (faceHostConfig != null) {
            client = proxy.client("FaceReindex", faceHostConfig);
            client.start();
        } else {
            client = null;
        }
    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        if (client == null) {
            throw new BadRequestException("Reindex faces not enabled here");
        }
        QueryConstructor qc = new QueryConstructor("/reindex?");
        qc.append("action", "store");
        qc.append("prefix", session.params().getLong("uid"));
        for (Map.Entry<String, List<String>> entry: session.params().entrySet()) {
            for (String value: entry.getValue()) {
                qc.append(entry.getKey(), value);
            }
        }

        AsyncClient client = this.client.adjust(session.context());

        client.execute(
            faceHostConfig.host(),
            new BasicAsyncRequestProducerGenerator(qc.toString()),
            StatusCodeAsyncConsumerFactory.ANY_GOOD,
            session.listener().adjustContextGenerator(client.httpClientContextGenerator()),
            new Callback(session));
    }

    private static class Callback extends AbstractProxySessionCallback<Object> {
        public Callback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
