package ru.yandex.search.disk.proxy.ipdd;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.protocol.HttpContext;

import ru.yandex.collection.LongPair;
import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.nio.AbstractAsyncCharArrayConsumer;
import ru.yandex.parser.string.CollectionParser;

public class DaysConsumer
    extends AbstractAsyncCharArrayConsumer<List<LongPair<Integer>>>
{
    private static final CollectionParser<
        List<String>,
        List<List<String>>,
        RuntimeException>
            PARSER =
                new CollectionParser<>(
                    new CollectionParser<>(x -> x, ArrayList::new, ' '),
                    ArrayList::new,
                    '\n');

    @Override
    public List<LongPair<Integer>> buildResult(
        final CharArrayProcessable data,
        final HttpContext context)
        throws Exception
    {
        List<List<String>> dayStrings = data.processWith(PARSER);
        List<LongPair<Integer>> days = new ArrayList<>(dayStrings.size());
        for (List<String> dayString: dayStrings) {
            // ignore empty response and the last line
            if (dayString.size() == 2 + 2) {
                String day = dayString.get(0);
                days.add(
                    new LongPair<>(
                        Long.parseLong(dayString.get(2)),
                        Integer.parseInt(
                            day.substring(day.indexOf('#') + 1))));
            }
        }
        return days;
    }
}

