package ru.yandex.search.disk.proxy.ipdd;

import java.util.List;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.collection.LongPair;
import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class DaysConsumerFactory
    implements HttpAsyncResponseConsumerFactory<List<LongPair<Integer>>>
{
    public static final DaysConsumerFactory INSTANCE =
        new DaysConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<
        List<LongPair<Integer>>> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    protected DaysConsumerFactory() {
    }

    @Override
    public DaysConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        return new DaysConsumer();
    }
}

