package ru.yandex.search.disk.proxy.ipdd;

import java.util.List;

import ru.yandex.collection.LongPair;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.NonNegativeLongValidator;
import ru.yandex.parser.uri.CgiParams;

public class DaysOptimizationContext {
    private static final long MILLIS_PER_DAY = 86400000L;

    private final CgiParams params;
    private final long version;
    private final Long to;
    private final int sinceDay;

    // CSOFF: ParameterNumber
    public DaysOptimizationContext(
        final ProxySession session,
        final List<LongPair<Integer>> days,
        final long daysRequired,
        final long maxDocs)
        throws BadRequestException
    {
        params = session.params();
        version = params.get(
            "page_load_timestamp",
            NonNegativeLongValidator.INSTANCE);
        to = params.get(
            "start_timestamp",
            null,
            NonNegativeLongValidator.INSTANCE);

        long lastTimestamp;
        if (to != null && to.longValue() < version) {
            lastTimestamp = to.longValue();
        } else {
            lastTimestamp = version;
        }
        long day = lastTimestamp / MILLIS_PER_DAY;
        int startDayPos = days.size() - 1;
        for (; startDayPos >= 0; --startDayPos) {
            if (day >= days.get(startDayPos).second()) {
                break;
            }
        }
        startDayPos = Math.min(days.size() - 1, startDayPos + 1);
        int sinceDayPos;
        int sinceDay;
        if (daysRequired >= startDayPos) {
            sinceDayPos = 0;
            sinceDay = 0;
        } else {
            sinceDayPos = Math.max(0, startDayPos - (int) daysRequired - 2);
            // for empty days this line won't be reachable
            sinceDay = days.get(sinceDayPos).second();
        }
        session.logger().fine(
            "Days for optimization: " + days.size()
            + ", start pos: " + startDayPos
            + ", days required: " + daysRequired
            + ", initial days pos: " + sinceDayPos);
        long left = maxDocs;
        int pos = startDayPos;
        for (; pos > sinceDayPos; --pos) {
            left -= days.get(pos).first();
            if (left < 0L) {
                sinceDay = days.get(Math.max(0, pos - 2)).second();
                break;
            }
        }
        session.logger().fine(
            "Total docs required: " + maxDocs
            + ", total docs accumulated: " + (maxDocs - left)
            + ", start position: " + pos
            + ", start day: " + sinceDay);
        this.sinceDay = sinceDay;
    }
    // CSON: ParameterNumber

    public CgiParams params() {
        return params;
    }

    public long version() {
        return version;
    }

    public Long to() {
        return to;
    }

    public int sinceDay() {
        return sinceDay;
    }
}

