package ru.yandex.search.disk.proxy.ipdd;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;

import ru.yandex.http.proxy.HttpEntitySendingCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.NonNegativeLongValidator;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.disk.proxy.AbstractUidProxyHandler;
import ru.yandex.search.disk.proxy.Proxy;
import ru.yandex.search.request.util.SearchRequestText;

public class IpddGroupHandler extends AbstractUidProxyHandler {
    public static final String SEARCH_URI =
        "/search?sort=multi(event_timestamp,id)";

    private static final String POSTFILTER = "postfilter";

    public IpddGroupHandler(final Proxy proxy) {
        super(proxy, proxy.ipddService());
    }

    @Override
    public void handle(
        final ProxySession session,
        final User user,
        final List<HttpHost> hosts)
        throws HttpException
    {
        QueryConstructor query = new QueryConstructor(SEARCH_URI);
        query.append("prefix", user.prefix().toString());
        long version = session.params().get(
            "page_load_timestamp",
            NonNegativeLongValidator.INSTANCE);
        StringBuilder text = new StringBuilder("version_day:[0 TO ");
        text.append(version);
        text.append(']');
        long from = session.params().get(
            "end_timestamp",
            NonNegativeLongValidator.INSTANCE);
        long to = session.params().get(
            "start_timestamp",
            NonNegativeLongValidator.INSTANCE);
        text.append(" AND event_timestamp:[");
        text.append(from);
        text.append(" TO ");
        text.append(to);
        text.append("] AND group_key:\"");
        String groupKey = session.params().getString("group_key");
        text.append(SearchRequestText.quoteEscape(groupKey));
        text.append('"');
        query.append("text", new String(text));
        query.copy(session.params(), "get");
        query.copyIfPresent(session.params(), "hr");
        query.copyIfPresent(session.params(), "json-type");
        query.copyIfPresent(session.params(), "skip-nulls");
        query.copyIfPresent(session.params(), "offset");
        query.copyIfPresent(session.params(), "max_amount", "length");
        query.append(POSTFILTER, "version <= " + version);
        AsyncClient client = proxy.searchClient().adjust(session.context());
        client.execute(
            hosts,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            NByteArrayEntityAsyncConsumerFactory.OK,
            session.listener().createContextGeneratorFor(client),
            new HttpEntitySendingCallback(session));
    }

    @Override
    public String toString() {
        return "Events group listing handler";
    }
}

