package ru.yandex.search.disk.proxy.ipdd;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeIntegerValidator;
import ru.yandex.search.rules.BasicRequestParams;

public class IpddRequestParams extends BasicRequestParams {
    private static final CollectionParser<String, Set<String>, Exception>
        GET_PARSER = new CollectionParser<>(
            NonEmptyValidator.INSTANCE,
            LinkedHashSet::new);

    private final User user;
    private final List<HttpHost> hosts;

    public IpddRequestParams(
        final ProxySession session,
        final User user,
        final List<HttpHost> hosts)
        throws BadRequestException
    {
        super(
            session.params().get(
                "offset",
                0,
                NonNegativeIntegerValidator.INSTANCE),
            session.params().get(
                "max_amount",
                Integer.MAX_VALUE,
                NonNegativeIntegerValidator.INSTANCE),
            session.params().get("get", GET_PARSER));
        this.user = user;
        this.hosts = hosts;
    }

    public User user() {
        return user;
    }

    public List<HttpHost> hosts() {
        return hosts;
    }
}

