package ru.yandex.search.disk.proxy.ipdd;

import java.io.IOException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.disk.proxy.AbstractDiskResultPrinter;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;

public class IpddResultPrinter extends AbstractDiskResultPrinter {
    public IpddResultPrinter(
        final ProxySession session,
        final SearchInfo searchInfo)
        throws BadRequestException
    {
        super(session, searchInfo);
    }

    @Override
    protected void writeSerp(
        final JsonWriter writer,
        final SearchResult searchResult)
        throws IOException
    {
        writer.startObject();
        writer.key("hitsCount");
        writer.value(searchResult.hitsCount());
        writer.key("search-options");
        writer.startObject();
        writer.key("request");
        writer.value(searchInfo.request());
        String suggest = searchInfo.suggest();
        if (suggest != null) {
            writer.key("suggest");
            writer.value(suggest);
        }
        String rule = searchInfo.erratumRule();
        if (rule != null) {
            writer.key("rule");
            writer.value(rule);
        }
        writer.endObject();
        writer.key("hitsArray");
        writer.startArray();
        for (SearchDocument document: searchResult.hitsArray()) {
            document.writeValue(writer);
        }
        writer.endArray();
        writer.endObject();
    }
}

