package ru.yandex.search.disk.proxy.ipdd;

import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.disk.proxy.AbstractDiskSearchService;
import ru.yandex.search.rules.SearchInfo;

public class IpddSearchService
    extends AbstractDiskSearchService<IpddRequestParams>
{
    public IpddSearchService(final User user, final List<HttpHost> hosts) {
        super(user, hosts);
    }

    @Override
    public IpddRequestParams createRequestParams(final ProxySession session)
        throws BadRequestException
    {
        return new IpddRequestParams(session, user, hosts);
    }

    @Override
    public IpddResultPrinter createCallback(
        final ProxySession session,
        final IpddRequestParams requestParams,
        final SearchInfo searchInfo)
        throws BadRequestException
    {
        return new IpddResultPrinter(session, searchInfo);
    }
}

