package ru.yandex.search.disk.proxy.querylanguage;

import java.text.ParseException;

import ru.yandex.parser.query.AndQuery;
import ru.yandex.parser.query.NotQuery;
import ru.yandex.parser.query.OrQuery;
import ru.yandex.parser.query.QueryAtom;
import ru.yandex.parser.query.QueryVisitor;

public abstract class AbstractLuceneQueryConstructor
    implements QueryVisitor<Void, ParseException>
{
    public static final String OR = " OR ";

    protected final LuceneQueryContext context;
    protected final StringBuilder request;

    protected AbstractLuceneQueryConstructor(
        final LuceneQueryContext context)
    {
        this.context = context;
        request = context.request();
    }

    @Override
    public Void visit(final AndQuery query) throws ParseException {
        request.append('(');
        visit(query.lhs());
        request.append(" AND ");
        // optimize a bit: skip NotQuery visit and selectAll request usage
        QueryAtom rhs = query.rhs();
        if (rhs instanceof NotQuery) {
            request.append("NOT ");
            visit(((NotQuery) rhs).query());
        } else {
            visit(rhs);
        }
        request.append(')');
        return null;
    }

    @Override
    public Void visit(final OrQuery query) throws ParseException {
        context.nonTrivial();
        request.append('(');
        visit(query.lhs());
        request.append(OR);
        visit(query.rhs());
        request.append(')');
        return null;
    }

    @Override
    public Void visit(final NotQuery query) throws ParseException {
        request.append('(');
        request.append(context.selectAll());
        request.append(" AND NOT ");
        visit(query.query());
        request.append(')');
        return null;
    }

}
