package ru.yandex.search.disk.proxy.querylanguage;


import java.util.Collection;
import java.util.Collections;

import org.joda.time.DateTimeZone;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.search.disk.proxy.Proxy;

public class LuceneQueryContext {
    private static final DateTimeZone MSK_TIMEZONE =
        DateTimeZone.forID("Europe/Moscow");

    private final StringBuilder request = new StringBuilder();
    private final String selectAll;
    private final DateTimeZone timezone;
    private final Collection<String> defaultScope;
    private boolean trivial = true;
    private PersonalDocument personalDocument;
    private String folder;
    private String personalDocumentText;
    private final ProxySession session;
    private boolean useHnsw = false;

    public LuceneQueryContext(
        final String selectAll,
        final ProxySession session,
        final Proxy server)
        throws BadRequestException
    {
        this.selectAll = selectAll;
        timezone = session.params().get(
            "tzoffset",
            MSK_TIMEZONE,
            x -> DateTimeZone.forOffsetMillis(Integer.parseInt(x) * 60000));
        this.defaultScope = Collections.emptyList();
        this.session = session;
    }

    public ProxySession session() {
        return session;
    }

    public StringBuilder request() {
        return request;
    }

    public String selectAll() {
        return selectAll;
    }

    public DateTimeZone timezone() {
        return timezone;
    }

    public Collection<String> defaultScope() {
        return defaultScope;
    }

    public boolean trivial() {
        return trivial;
    }

    public void nonTrivial() {
        trivial = false;
    }

    public void personalDocument(final PersonalDocument personalDocument, final String text) {
        this.personalDocument = personalDocument;
        this.personalDocumentText = text;
    }

    public PersonalDocument personalDocument() {
        return personalDocument;
    }

    public String personalDocumentText() {
        return personalDocumentText;
    }

    public String folder() {
        return folder;
    }

    public void folder(final String folder) {
        this.folder = folder;
    }

    public void setUseHnsw(boolean useHnsw) {
        this.useHnsw = useHnsw;
    }

    public boolean getUseHnsw() {
        return useHnsw;
    }
}

