package ru.yandex.search.disk.proxy.rules;

import java.util.HashSet;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.CgiParams;

public class AuxFolders extends HashSet<String> {
    private static final long serialVersionUID = 0L;

    private final String key;
    private final boolean simpleKey;

    public AuxFolders(final CgiParams params) throws BadRequestException {
        key = params.get("key", null, NonEmptyValidator.INSTANCE);
        simpleKey = key != null
            && key.indexOf('/', 1) == key.length() - 2
            && key.charAt(0) == '/'
            && key.charAt(key.length() - 1) == '*';
        if (simpleKey) {
            add(key.substring(1, key.length() - 2));
        } else {
            params.getAll(
                "aux_folder",
                null,
                NonEmptyValidator.INSTANCE,
                this);
        }
    }

    public String key() {
        return key;
    }

    public boolean simpleKey() {
        return simpleKey;
    }
}

