package ru.yandex.search.disk.proxy.rules;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.parser.query.QueryAtom;
import ru.yandex.parser.query.QueryParser;
import ru.yandex.parser.query.QueryPrintingVisitor;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.disk.proxy.DiskRequestParams;
import ru.yandex.search.disk.proxy.Proxy;
import ru.yandex.search.disk.proxy.querylanguage.DiskLuceneQueryConstructor;
import ru.yandex.search.disk.proxy.querylanguage.LuceneQueryContext;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.search.result.BasicSearchResult;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class DocumentsSearchRule implements SearchRule<SearchResult, DiskRequestParams, SearchInfo> {
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> commonNext;
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> documentNext;
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> plainNext;
    private final Proxy proxy;

    public DocumentsSearchRule(
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> commonNext,
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> documentNext,
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> plainNext,
        final Proxy proxy)
    {
        this.commonNext = commonNext;
        this.documentNext = documentNext;
        this.plainNext = plainNext;
        this.proxy = proxy;
    }

    @Override
    public void execute(
        final SearchRequest<SearchResult, DiskRequestParams, SearchInfo> request) throws HttpException
    {
        CgiParams params = request.cgiParams();

        String requestText = request.searchInfo().request();
        //String queryParserRequest = null;
        if (!new SearchRequestText(requestText).isEmpty()) {
            try {
                LuceneQueryContext context = new LuceneQueryContext("", request.session(), proxy);
                DiskLuceneQueryConstructor query =
                    new DiskLuceneQueryConstructor(context);
                QueryAtom queryAtom = new QueryParser(requestText).parse();
                queryAtom.accept(query);
                //session.httpSession().server().queryLanguageHit(true);
                //session.httpSession().server()
                    //.queryLanguageSimpleRequest(context.trivial());
                if (context.personalDocument() != null) {
                    request.session().logger().info("Personal document " + context.personalDocument());
                    StringBuilder sb = new StringBuilder(
                        "QueryParser parsed non-trivial query:\n");
                    queryAtom.accept(new QueryPrintingVisitor(sb));
                    request.session().logger().info(new String(sb));
                    //request.searchInfo().setSuggest(request.searchInfo().request(), null);
                    //request.searchInfo().setRequest(query.request(), null);
                    if (context.folder() != null) {
                        DoubleFutureCallback<? super SearchResult, ? super SearchResult> dfcb
                            = new DoubleFutureCallback<>(
                                new ConcatCallback(
                                    request.callback(),
                                    request.requestParams().length() + request.requestParams().offset()));

                        CgiParams folderParams = new CgiParams(params);
                        folderParams.replace(
                            "text",
                            "mediatype:9");
                        folderParams.remove("aux_folder");
                        folderParams.replace("key",  "/disk/Сканы/Личные документы/" + context.folder() + "*");
                        request.session().logger().info("FolderParams " + folderParams);
                        plainNext.execute(request.withCallback(dfcb.first()).withCgiParams(folderParams));
                        params.replace("text", context.personalDocumentText());
                        params.replace("dssm_threshold", String.valueOf(context.personalDocument().threshold()));
                        documentNext.execute(request.withCallback(dfcb.second()).withCgiParams(params));
                    } else {
                        params.replace("text", context.personalDocumentText());
                        params.replace("dssm_threshold", String.valueOf(context.personalDocument().threshold()));
                        documentNext.execute(request.withCgiParams(params));
                    }

                    return;
                } else {
                    request.session().logger().info("Personal document not found");
                    if (context.getUseHnsw()) {
                        request.cgiParams().add("use_hnsw", "1");
                    }
                    StringBuilder sb = new StringBuilder();
                    queryAtom.accept(new QueryPrintingVisitor(sb));
                    request.session().logger().info(new String(sb));
                }
                //queryParserRequest = query.request();
            } catch (IOException | ParseException e) {
                request.session().logger().log(
                    Level.WARNING,
                    "QueryParser failed on string '" + requestText + '\'',
                    e);
                //session.httpSession().server().queryLanguageHit(false);
            }
        }

        commonNext.execute(request);
    }

    private static class ConcatCallback
        extends AbstractFilterFutureCallback<Map.Entry<SearchResult, SearchResult>, SearchResult>
    {
        private final int length;
        public ConcatCallback(final FutureCallback<? super SearchResult> callback, final int length) {
            super(callback);
            this.length = length;
        }

        private void fill(final SearchResult result, final List<SearchDocument> docs, final Set<String> ids) {
            for (SearchDocument document: result.hitsArray()) {
                if (ids.add(document.attrs().get("id"))) {
                    docs.add(document);
                    if (docs.size() >= length) {
                        return;
                    }
                }
            }
        }

        @Override
        public void completed(final Map.Entry<SearchResult, SearchResult> entry) {
            Set<String> ids = new HashSet<>(length << 1);
            List<SearchDocument> docs = new ArrayList<>(length);
            fill(entry.getKey(), docs, ids);
            fill(entry.getValue(), docs, ids);
            callback.completed(new BasicSearchResult(docs, docs.size()));
        }
    }
}
