package ru.yandex.search.disk.proxy.rules;

import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.disk.proxy.DiskRequestParams;
import ru.yandex.search.disk.proxy.Proxy;
import ru.yandex.search.disk.proxy.UserSplit;
import ru.yandex.search.disk.proxy.UserSplitAsyncResponseConsumerFactory;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class ExperimentsRule
    implements SearchRule<SearchResult, DiskRequestParams, SearchInfo>
{
    private static final String DISK_SEARCH_EXP_FLAG_PREFIX = "disk_search_";
    private static final String EXPS_FLAGS_SESSION_INFO = "exps_flags";
    private static final String TESTIDS_SESSION_INFO = "exps_ids";

    private static final String SERVICE_NAME = "disk";
    private static final String ROUTE = "/" + SERVICE_NAME + "?";
    private static final String DEFAULT_USER_AGENT = "disk-search";

    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next;

    private final AsyncClient client;
    private final ImmutableHttpHostConfig userSplitConfig;

    public ExperimentsRule(
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next,
        final Proxy proxy)
    {
        this.client = proxy.uaasClient();
        this.next = next;
        this.userSplitConfig = proxy.config().userSplitConfig();
    }

    @Override
    public void execute(
        final SearchRequest<SearchResult, DiskRequestParams, SearchInfo> request)
        throws HttpException
    {
        PrefixedLogger logger = request.session().logger();
//        HttpRequest httpRequest = request.session().request();

//        Header enabledBoxed =
//            httpRequest.getFirstHeader(YandexHeaders.X_ENABLED_BOXES);

//        Header realIpHeader = httpRequest.getLastHeader(YandexHeaders.X_REAL_IP);

        String uid = request.requestParams().user().prefix().toStringFast();

//        if (enabledBoxed == null &&
//            (userSplitConfig == null || uid == null || realIpHeader == null))
//        {
//            this.next.execute(request);
//            request.session().logger().warning("Skipping fetching experiments");
//            return;
//        }

//        Header userAgentHeader =
//            session.requestInfo().request()
//                .getLastHeader(HttpHeaders.USER_AGENT);

        QueryConstructor uri = new QueryConstructor(ROUTE);
        uri.append("uuid", uid);
        uri.append("service", SERVICE_NAME);

        BasicAsyncRequestProducerGenerator generator =
            new BasicAsyncRequestProducerGenerator(uri.toString());
//        generator.addHeader(
//            YandexHeaders.X_FORWARDED_FOR_Y,
//            realIpHeader.getValue());

//        if (userAgentHeader != null) {
//            generator.addHeader(userAgentHeader);
//        } else {
//            generator.addHeader(HttpHeaders.USER_AGENT, DEFAULT_USER_AGENT);
//        }

        generator.addHeader(HttpHeaders.USER_AGENT, DEFAULT_USER_AGENT);

        logger.info(generator.toString());

        request.session().subscribeForCancellation(
            client.execute(
                userSplitConfig.host(),
                generator,
                UserSplitAsyncResponseConsumerFactory.INSTANCE,
                new Callback(request)));
    }

    private class Callback
        implements FutureCallback<UserSplit>
    {
        private final SearchRequest<SearchResult, DiskRequestParams, SearchInfo> request;

        public Callback(final SearchRequest<SearchResult, DiskRequestParams, SearchInfo> request) {
            this.request = request;
        }

        protected void addFlagsToCgi(final UserSplit userSplit) throws JsonException {
            CgiParams params = request.cgiParams();

            StringBuilder flagsAdded = new StringBuilder();
            StringBuilder testIds = new StringBuilder();
            for (JsonObject flagsList: userSplit.flags()) {
                JsonList list = flagsList.asList();
                if (list.size() > 0) {
                    for (JsonObject item: list) {
                        JsonMap context = item.asMap().getMap("CONTEXT");
                        if (context != null) {
                            JsonMap disk = context.getMapOrNull("DISK");
                            if (disk != null) {
                                JsonList flags = disk.getList("flags");
                                for (JsonObject flagObj: flags) {
                                    String flagName = flagObj.asString().trim().toLowerCase(Locale.ENGLISH);
                                    if (flagName.startsWith(DISK_SEARCH_EXP_FLAG_PREFIX)) {
                                        flagsAdded.append(flagName);
                                        flagsAdded.append(',');
                                        userSplit.toStringBuilder(testIds);
                                        testIds.append(',');
                                        params.putIfAbsent(
                                            flagName,
                                            Collections.singletonList(Boolean.TRUE.toString()));
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (flagsAdded.length() > 0) {
                flagsAdded.setLength(flagsAdded.length() - 1);
                if (testIds.length() > 0) {
                    testIds.setLength(testIds.length() - 1);
                }

                String flags = flagsAdded.toString();
                request.session().logger().info("Adding flags: " + flags);
                request.session().connection().setSessionInfo(EXPS_FLAGS_SESSION_INFO, flags);
                request.session().connection().setSessionInfo(TESTIDS_SESSION_INFO, testIds.toString());
            }
        }

        @Override
        public void completed(final UserSplit userSplit) {
            try {
                addFlagsToCgi(userSplit);
            } catch (JsonException je) {
                request.session().logger().log(Level.WARNING, "Failed to parse user split", je);
            }

//            request.session().logger().info(
//                "UserSplit: "
//                    + String.valueOf(userSplit));
            next();
        }

        protected void next() {
            try {
                next.execute(request);
            } catch (HttpException e) {
                request.callback().failed(e);
            }
        }

        @Override
        public void failed(final Exception e) {
            request.session().logger()
                .log(Level.WARNING, "UserSplit failed", e);

            next();
        }

        @Override
        public void cancelled() {
            next();
        }
    }
}
