package ru.yandex.search.disk.proxy.rules;

import java.util.Locale;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.ErrorSuppressingFutureCallback;
import ru.yandex.http.util.RequestErrorType;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.disk.proxy.DiskRequestParams;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class NameKeywordSearchRule
    implements SearchRule<SearchResult, DiskRequestParams, SearchInfo>
{
    private static final String TEXT = "text";

    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next;

    public NameKeywordSearchRule(
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final SearchRequest<SearchResult, DiskRequestParams, SearchInfo>
        request)
        throws HttpException
    {
        CgiParams cgiParams = new CgiParams(request.cgiParams());
        String text =
            new SearchRequestText.SuggestWordsModifier(
                cgiParams.getLocale("locale", Locale.ROOT))
                .apply(cgiParams.getString(TEXT, ""));
        StringBuilder sb = new StringBuilder("type:file");
        if (!text.isEmpty()) {
            sb.append(" AND name:*");
            sb.append(SearchRequestText.fullEscape(text, true));
            sb.append('*');
        }
        cgiParams.replace(TEXT, new String(sb));

        // workaround:now backend could do 400 on request with *xxxx*
        // we should not fail all request
        FutureCallback<? super SearchResult> callback =
            new ErrorSuppressingFutureCallback<>(
                request.callback(),
                (e) -> RequestErrorType.IO,
                SearchResult.EMPTY);

        next.execute(
            request.withCgiParams(cgiParams).withCallback(callback));
    }
}

