package ru.yandex.search.disk.proxy.rules;

import org.apache.http.HttpException;

import ru.yandex.search.disk.proxy.DiskRequestParams;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class NamedRule
    implements SearchRule<SearchResult, DiskRequestParams, SearchInfo>
{
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next;
    private final String name;

    public NamedRule(
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next,
        final String name)
    {
        this.next = next;
        this.name = name;
    }

    @Override
    public void execute(
        final SearchRequest<SearchResult, DiskRequestParams, SearchInfo>
        request)
        throws HttpException
    {
        next.execute(request);
    }

    public String name() {
        return name;
    }
}

