package ru.yandex.search.disk.proxy.rules;

import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;

import org.apache.http.HttpException;

import ru.yandex.parser.query.QueryAtom;
import ru.yandex.parser.query.QueryParser;
import ru.yandex.parser.query.QueryPrintingVisitor;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.disk.proxy.DiskRequestParams;
import ru.yandex.search.disk.proxy.Proxy;
import ru.yandex.search.disk.proxy.querylanguage.DiskLuceneQueryConstructor;
import ru.yandex.search.disk.proxy.querylanguage.LuceneQueryContext;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class QueryLanguageSearchRule implements SearchRule<SearchResult, DiskRequestParams, SearchInfo> {
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> commonNext;
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> documentNext;
    private final Proxy proxy;

    public QueryLanguageSearchRule(
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> commonNext,
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> documentNext,
        final Proxy proxy)
    {
        this.commonNext = commonNext;
        this.documentNext = documentNext;
        this.proxy = proxy;
    }

    @Override
    public void execute(
        final SearchRequest<SearchResult, DiskRequestParams, SearchInfo> request) throws HttpException
    {
        CgiParams params = request.cgiParams();

        String requestText = request.searchInfo().request();
        //String queryParserRequest = null;
        if (!new SearchRequestText(requestText).isEmpty()) {
            try {
                LuceneQueryContext context = new LuceneQueryContext("", request.session(), proxy);
                DiskLuceneQueryConstructor query =
                    new DiskLuceneQueryConstructor(context);
                QueryAtom queryAtom = new QueryParser(requestText).parse();
                queryAtom.accept(query);
                //session.httpSession().server().queryLanguageHit(true);
                //session.httpSession().server()
                //.queryLanguageSimpleRequest(context.trivial());
                if (context.personalDocument() != null) {
                    request.session().logger().info("Personal document " + context.personalDocument());
                    StringBuilder sb = new StringBuilder(
                        "QueryParser parsed non-trivial query:\n");
                    queryAtom.accept(new QueryPrintingVisitor(sb));
                    request.session().logger().info(new String(sb));
                    request.searchInfo().setSuggest(request.searchInfo().request(), null);
                    request.searchInfo().setRequest(query.request(), null);
                    params.replace("dssm_threshold", String.valueOf(context.personalDocument().threshold()));
                    documentNext.execute(request);
                    return;
                } else {
                    request.session().logger().info("Personal document not found");
                    StringBuilder sb = new StringBuilder();
                    queryAtom.accept(new QueryPrintingVisitor(sb));
                    request.session().logger().info(new String(sb));
                }
                //queryParserRequest = query.request();
            } catch (IOException | ParseException e) {
                request.session().logger().log(
                    Level.WARNING,
                    "QueryParser failed on string '" + requestText + '\'',
                    e);
                //session.httpSession().server().queryLanguageHit(false);
            }
        }

        commonNext.execute(request);
    }
}
