package ru.yandex.search.disk.proxy.rules;

import java.util.Collections;

import org.apache.http.HttpException;

import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.disk.proxy.DiskRequestParams;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class SelectByFlagSearchRule implements SearchRule<SearchResult, DiskRequestParams, SearchInfo> {

    //private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> multiSearchRule;
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> orderScopeExp;
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> speedExpRule;

    public SelectByFlagSearchRule(
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> regRule,
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> otherOrderRule,
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> expSpeedRule)
    {
        //this.multiSearchRule = regRule;
        this.orderScopeExp = otherOrderRule;
        this.speedExpRule = expSpeedRule;
    }

    @Override
    public void execute(
        final SearchRequest<SearchResult, DiskRequestParams, SearchInfo> request)
        throws HttpException
    {
        CgiParams params = request.cgiParams();
        if (params.getBoolean("disk_search_ranking_exp_speed", false)) {
            request.session().logger().info("disk_search_ranking_exp_speed enabled");
            request.cgiParams().put("search_failover", Collections.singletonList("1000"));
            speedExpRule.execute(request);
        } else if (params.getBoolean("disk_search_ranking_exp", false)) {
            request.session().logger().info("disk_search_ranking_exp enabled");
            orderScopeExp.execute(request);
        } else {
            speedExpRule.execute(request);
        }
    }
}
