package ru.yandex.search.disk.proxy.rules;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.FilterFutureCallback;
import ru.yandex.search.disk.proxy.DiskRequestParams;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class SetScopeRule
    implements SearchRule<SearchResult, DiskRequestParams, SearchInfo>
{
    private final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next;
    private final String scope;

    public SetScopeRule(
        final SearchRule<SearchResult, DiskRequestParams, SearchInfo> next,
        final String scope)
    {
        this.next = next;
        this.scope = scope;
    }

    @Override
    public void execute(
        final SearchRequest<SearchResult, DiskRequestParams, SearchInfo>
        request)
        throws HttpException
    {
        next.execute(
            request.withCallback(new Callback(request.callback(), scope)));
    }

    private static class Callback extends FilterFutureCallback<SearchResult> {
        private final String scope;

        Callback(
            final FutureCallback<? super SearchResult> callback,
            final String scope)
        {
            super(callback);
            this.scope = scope;
        }

        @Override
        public void completed(final SearchResult result) {
            for (SearchDocument document: result.hitsArray()) {
                document.attrs().put("scope", scope);
            }
            callback.completed(result);
        }
    }
}

