package ru.yandex.search.disk.proxy.suggest;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public class BasicSuggestItem implements SuggestItem {
    private final String id;
    private final SuggestType type;
    private final String request;
    private final String text;
    private final JsonMap payload;

    // CSOFF: ParameterNumber
    public BasicSuggestItem(
        final String id,
        final SuggestType type,
        final String request,
        final String text,
        final JsonMap payload)
        throws JsonException
    {
        this.id = id;
        this.type = type;
        this.request = request;
        this.text = text;
        this.payload = payload;
    }
    // CSON: ParameterNumber

    @Override
    public String id() {
        return id;
    }

    @Override
    public SuggestType type() {
        return type;
    }

    @Override
    public String request() {
        return request;
    }

    @Override
    public String text() {
        return text;
    }

    @Override
    public JsonMap payload() {
        return payload;
    }
}

