package ru.yandex.search.disk.proxy.suggest;

import ru.yandex.json.dom.JsonMap;

public interface SuggestItem {
    // Some unique id which allows to deduplicate items came from different
    // suggest rules
    String id();

    // Suggest type
    SuggestType type();

    // Suggest request, may differ from original request because of
    // preprocessing, transliteration etc.
    String request();

    // Suggest text, which should be displayed and highlighted with request
    String text();

    // Additional data, like file id or mimetype. May be empty for some suggest
    // types, like history
    JsonMap payload();
}

