package ru.yandex.search.disk.proxy.suggest;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class SuggestResult {
    private final Map<SuggestType, List<SuggestItem>> suggests;

    public SuggestResult(
        final Map<SuggestType, List<SuggestItem>> suggests)
    {
        if (suggests.isEmpty()) {
            this.suggests = Collections.emptyMap();
        } else {
            this.suggests = new EnumMap<>(suggests);
        }
    }

    public Map<SuggestType, List<SuggestItem>> suggests() {
        return suggests;
    }
}

