#!/bin/bash
set -exo pipefail

source disk-config-base.sh

case "$NANNY_SERVICE_ID" in
    disk_search_proxy_prod)
        export SERVER_NAME=disk-secure.search.yandex.net
        export HTTP_PORT=19502
        export HTTPS_PORT=443
        # noc bug - no traffic for producer balancer in myt passes, workaround
        export PRODUCER_INDEXING_HOST=${PORTO_HOST}:19922
        export FACE_INDEXER_HOST="disk-search-face-prod-1.sas.yp-c.yandex.net:26551"
        export MOP_HOST="disk-search-mop-prod.pers.yandex.net:80"
	;;
   disk-search-proxy-yp-prod)
        export SERVER_NAME=disk-proxy.pers.yandex.net
        export HTTP_PORT=80
        export HTTPS_PORT=443
        export PRODUCER_INDEXING_HOST=disk-producer.search.yandex.net:19922
        export FACE_INDEXER_HOST="disk-search-face-prod-1.sas.yp-c.yandex.net:26551"
        export MOP_HOST="disk-search-mop-prod.pers.yandex.net:80"
	;; 
    disk_search_proxy_test)
        # Need create this balancer
        export SERVER_NAME=disk-secure-test.search.yandex.net
        export HTTP_PORT=21403
        export HTTPS_PORT=443
        export FACE_INDEXER_HOST="disk-search-face-test-1.sas.yp-c.yandex.net:26551"
        export MOP_HOST="disk-search-mop-test.pers.yandex.net:80"
	;;
    disk_search_proxy_mass)
        export SERVER_NAME=disk-mass-processing.search.yandex.net
        export PRODUCER_INDEXING_HOST=disk-producer.n.yandex-team.ru:80
        export HTTP_PORT=80
        export HTTPS_PORT=443
        export FACE_INDEXER_HOST="disk-search-face-prod-1.sas.yp-c.yandex.net:26551"
        export MOP_HOST="disk-search-mop-prod.pers.yandex.net:80"
	;;
esac

