#!/bin/bash
set -exo pipefail

source config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH="$BSCONFIG_IDIR:$BSCONFIG_IDIR/yadisk_search_proxy"

MB=$((1024 * 1024))
GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
GB2=$((GB + GB))

if [ -z "$MEMORY_LIMIT" ]; then
  XMX=$(portoctl get self memory_limit_total)
  XMX=$((XMX - GB1_5))
else
  XMX=$((MEMORY_LIMIT - GB1_5))
fi

if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1 + 0.2)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1 + 0.2)}')
fi

XMX=$((XMX / MB))
#XMX=$(jq -r '.container.constraints["memory_guarantee"]' $BSCONFIG_IDIR/dump.json | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))
MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-Xgcpolicy:balanced -XX:ActiveProcessorCount=${CPU_CORES} -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=yadisk_search_proxy \
    -cp $CLASSPATH \
    ru.yandex.search.disk.proxy.Proxy \
    yadisk-search-proxy.conf

