#!/bin/sh

GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
GB2=$((GB + GB))
XMX=$(portoctl get self memory_limit_total)
XMX=$((XMX-GB2))

mkdir -p /webcache/javasharedresources/512m >/dev/null 2>&1

export GC_ARGS="
-XX:ActiveProcessorCount=5
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/cores
-XcompilationThreads1
-Xmx${XMX}
-Xms1G
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahGCMode=traversal
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=10
-XX:+PrintCodeCache
-XX:ParallelGCThreads=7
-XX:MaxHeapFreeRatio=20
-XX:MinHeapFreeRatio=10
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log"
