#!/bin/bash
set -exo pipefail
source district_backend_config.sh
source classpath.sh

./check_its_status.py || exit 1

portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
-DINUM=$INUM
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR

source district_backend_gc_args.sh

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=district_backend \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    ru.yandex.dispatcher.consumer.ConsumerServer -config district_backend_consumer.conf ";" \
    ru.yandex.msearch.Daemon -config district_search_backend.conf
