package ru.yandex.search.district;

import java.util.Locale;

public enum DistrictPopularRequestsFields {
    REQUEST_TEXT,
    REQUEST_TEXT_WS,
    REQUEST_COUNT,
    REQUEST_CITIES,
    REQUEST_DISTRICTS;

    private static final int REQUESTS_SHARD = 30;

    private final String fieldName;

    DistrictPopularRequestsFields(final String fieldName) {
        this.fieldName = fieldName;
    }

    DistrictPopularRequestsFields() {
        this.fieldName = name().toLowerCase(Locale.ROOT);
    }

    public String fieldName() {
        return fieldName;
    }

    public static String url(final String request) {
        return "reqs_" + request;
    }

    public static long prefix() {
        return REQUESTS_SHARD;
    }
}

