#!/bin/bash
set -exo pipefail

source config.sh
source classpath.sh


CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

XMX=$(jq -r '.container.constraints["memory_guarantee"]' $BSCONFIG_IDIR/dump.json | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))
MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M"
GC_ARGS="-XX:+UnlockExperimentalVMOptions -XX:+UseZGC -XX:ConcGCThreads=2 -XX:ParallelGCThreads=8 -XX:+DisableExplicitGC -verbose:gc -Xlog:gc*:/logs/gc.log"
DUMP_ARGS=""
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=district_indexer \
    -DDISTRICT_QUEUE=$DISTRICT_QUEUE \
    -DDISTRICT_CITY_QUEUE=$DISTRICT_CITY_QUEUE \
    -cp $CLASSPATH \
    ru.yandex.search.district.indexer.DistrictIndexerProxy \
    district-indexer.conf

