package ru.yandex.search.district.indexer;

import java.io.IOException;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.StatusCodeAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;

public class BasicDistrictIndexer {
    private static final int BATCH_SIZE = 200;

    private MultipartEntityBuilder builder;
    private int parts = 0;

    private final DistrictIndexerProxy proxy;
    private final AsyncClient client;
    private final ProxySession session;
    private final MultiFutureCallback<Object> mfcb;
    private final String service;

    // CSOFF: ParameterNumber
    public BasicDistrictIndexer(
        final DistrictIndexerProxy proxy,
        final ProxySession session,
        final String service,
        final FutureCallback<Object> callback)
    {
        this.proxy = proxy;
        this.session = session;
        this.service = service;
        this.mfcb = new MultiFutureCallback<>(callback);
        this.client = proxy.producerClient();
        this.createPartsBuilder();
    }
    // CSON: ParameterNumber

    public void index(
        final StringBuilder uri,
        final int shard,
        final StringBuilder body)
        throws IOException
    {
        builder.addPart(
            FormBodyPartBuilder
                .create()
                .addField(
                    YandexHeaders.ZOO_SHARD_ID,
                    String.valueOf(shard))
                .addField(
                    YandexHeaders.URI,
                    uri.toString())
                .setBody(
                    new StringBody(body.toString(),
                        ContentType.APPLICATION_JSON))
                .setName("envelope.json")
                .build());
        parts += 1;

        if (parts >= BATCH_SIZE) {
            send();
            parts = 0;
            createPartsBuilder();
        }
    }

    private void send() throws IOException {
        final BasicAsyncRequestProducerGenerator post =
            new BasicAsyncRequestProducerGenerator(
                "/?index&batch-size=" + parts
                    + "&service=" + service,
                builder.build());

        client.execute(
            proxy.producerHost(),
            post,
            StatusCodeAsyncConsumerFactory.ANY_GOOD,
            session.listener().adjustContextGenerator(
                client.httpClientContextGenerator()),
            mfcb.newCallback());
    }

    private void createPartsBuilder() {
        builder = MultipartEntityBuilder.create();
        builder.setMimeSubtype("mixed");
    }

    public void done() throws IOException {
        if (parts > 0) {
            send();
        }

        mfcb.done();
    }
}
