package ru.yandex.search.district.indexer;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.district.DistrictEntityType;
import ru.yandex.search.district.DistrictFields;

public class DeleteDistrictHandler implements DistrictIndexHandler {
    private static final String PREFIX = "prefix";
    private static final String DOCS = "docs";

    private static final Map<DistrictEntityType, List<String>> PRESERVE_FIELDS
        = DistrictFields.preserveFields();

    @Override
    public void handle(
        final AbstractIndexContext context,
        final BasicDistrictIndexer indexer)
        throws JsonException, IOException
    {
        StringBuilder uri = context.uri(new StringBuilder("/delete?"));

        StringBuilder sb = new StringBuilder();
        JsonWriter writer = JsonType.NORMAL.create(new StringBuilderWriter(sb));
        writer.startObject();
        writer.key(PREFIX);
        writer.value(context.prefix());
        writer.key(DOCS);
        writer.startArray();
        writer.startObject();
        writer.key(DistrictFields.ID.field());
        writer.value(context.id());
        writer.endObject();
        writer.endArray();
        writer.endObject();

        indexer.index(uri, context.shard(), sb);

        if (context.entityType() == DistrictEntityType.COMMENT) {
            uri = context.uri(new StringBuilder("/update?"));
            String eventId =
                context.data().get(DistrictFields.EVENT_ID.field());
            String luceneEventId = context.lucenePostId(eventId);

            sb.setLength(0);
            writer.reset();

            writer.startObject();
            writer.key(PREFIX);
            writer.value(context.prefix());
            writer.key("PreserveFields");
            writer.value(PRESERVE_FIELDS.get(DistrictEntityType.EVENT));
            writer.key(DOCS);
            writer.startArray();
            writer.startObject();
            writer.key(DistrictFields.ID.field());
            writer.value(luceneEventId);

            writer.key(DistrictFields.COMMENTS_COUNT.field());
            writer.startObject();
            writer.key("inc");
            writer.startArray();
            writer.value(-1);
            writer.endArray();
            writer.endObject();
            writer.endObject();
            writer.endArray();
            writer.endObject();

            indexer.index(uri, context.shard(), sb);
        }
    }
}
