package ru.yandex.search.district.indexer;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.district.DistrictConstants;
import ru.yandex.search.district.DistrictEntityType;
import ru.yandex.search.district.DistrictFields;

public class DistrictBaseIndexContext extends AbstractIndexContext {
    private final String id;

    public DistrictBaseIndexContext(
        final Long prefix,
        final ProxySession session,
        final JsonMap entry)
        throws JsonException
    {
        super(
            prefix,
            session,
            entry);

        this.data.put(DistrictFields.DISTRICT_ID.field(), prefix.toString());
        this.data.put(
            DistrictFields.INDEX_TYPE.field(),
            DistrictConstants.DISTRICT_INDEX_TYPE);

        this.id = DistrictFields.id(entityType, prefix, entityId);
        this.data.put(DistrictFields.ID.field(), id);
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public String lucenePostId(final String eventId) {
        return DistrictFields.id(
            DistrictEntityType.EVENT,
            prefix(),
            eventId);
    }

    @Override
    protected String service() {
        return DistrictConstants.DISTRICT_QUEUE;
    }

    @Override
    public long prefix() {
        return prefix;
    }
}
