package ru.yandex.search.district.indexer;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.search.district.DistrictConstants;
import ru.yandex.search.district.DistrictEntityType;
import ru.yandex.search.district.DistrictFields;

public class DistrictCityBaseContext extends AbstractIndexContext {
    protected final String id;
    private final Long districtId;

    public DistrictCityBaseContext(
        final Long districtId,
        final ProxySession session,
        final JsonMap entry)
        throws JsonException
    {
        super(
            entry.getMap("fields").getLong(DistrictFields.CITY_ID.field()),
            session,
            entry);

        this.districtId = districtId;
        this.id = DistrictFields.cityBasedId(
            entityType,
            prefix,
            districtId,
            entityId);
        this.data.put(DistrictFields.ID.field(), id);
        this.data.put(
            DistrictFields.DISTRICT_ID.field(),
            districtId.toString());
        this.data.put(
            DistrictFields.INDEX_TYPE.field(),
            DistrictConstants.CITY_INDEX_TYPE);
    }

    @Override
    protected String service() {
        return DistrictConstants.DISTRICT_CITY_QUEUE;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public String lucenePostId(final String eventId) {
        return DistrictFields.cityBasedId(
            DistrictEntityType.EVENT,
            prefix(),
            districtId,
            eventId);
    }
}
