package ru.yandex.search.district.indexer;

import java.io.IOException;

import org.apache.http.HttpHost;

import ru.yandex.collection.Pattern;
import ru.yandex.dispatcher.producer.Producer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.district.indexer.config.ImmutableDistrictIndexerConfig;

public class DistrictIndexerProxy extends Producer {
    private final AsyncClient producerClient;
    private final HttpHost producerHost;
    private final ImmutableDistrictIndexerConfig indexerConfig;

    public DistrictIndexerProxy(final ImmutableDistrictIndexerConfig config)
        throws IOException, ConfigException
    {
        super(config);

        indexerConfig = config;
        producerClient =
            client("ProducerClient", config.producerConfig());

        producerHost = config.producerConfig().host();

        register(
            new Pattern<>("/api/district/index", true),
            new DistrictIndexUpdateHandler(this),
            RequestHandlerMapper.POST);

        register(
            new Pattern<>("/api/district/index/request", true),
            new DistrictRequestIndexHandler(this));
    }

    public AsyncClient producerClient() {
        return producerClient;
    }

    public HttpHost producerHost() {
        return producerHost;
    }

    public ImmutableDistrictIndexerConfig indexerConfig() {
        return indexerConfig;
    }
}
