package ru.yandex.search.district.indexer;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.StatusCodeAsyncConsumerFactory;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.district.DistrictConstants;
import ru.yandex.search.district.DistrictFields;
import ru.yandex.search.district.DistrictPopularRequestsFields;

public class DistrictRequestIndexHandler implements ProxyRequestHandler {
    private static final String REQUEST = "request";

    private final DistrictIndexerProxy proxy;

    public DistrictRequestIndexHandler(final DistrictIndexerProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        String request = session.params().getString(REQUEST);
        request = request.trim().replaceAll("\\s+", " ");
        StringBuilderWriter sbw = new StringBuilderWriter();
        long prefix = DistrictPopularRequestsFields.prefix();
        try (JsonWriter writer = JsonType.DOLLAR.create(sbw)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(prefix);
            writer.key("AddIfNotExists");
            writer.value(true);
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key(DistrictFields.ID.field());
            writer.value("reqs_" + request);
            writer.key(DistrictFields.INDEX_TYPE.field());
            writer.value(DistrictConstants.POPULAR_REQS_INDEX_TYPE);
            writer.key(DistrictPopularRequestsFields.REQUEST_TEXT.fieldName());
            writer.value(request);
            writer.key(DistrictPopularRequestsFields.REQUEST_COUNT.fieldName());
            writer.startObject();
            writer.key("inc");
            writer.startArray();
            writer.value(1);
            writer.endArray();
            writer.endObject();
            writer.endObject();
            writer.endArray();
            writer.endObject();
        }

        QueryConstructor qc =
            new QueryConstructor("/update?popular-requests");
        qc.append("service", DistrictConstants.DISTRICT_CITY_QUEUE);
        qc.append("shard", prefix);
        qc.append(REQUEST, request);
        final BasicAsyncRequestProducerGenerator post =
            new BasicAsyncRequestProducerGenerator(
                qc.toString(),
                sbw.toString());

        post.addHeader(
            YandexHeaders.ZOO_SHARD_ID,
            String.valueOf(prefix));

        proxy.producerClient().execute(
            proxy.producerHost(),
            post,
            StatusCodeAsyncConsumerFactory.ANY_GOOD,
            session.listener().adjustContextGenerator(
                proxy.producerClient().httpClientContextGenerator()),
            new Callback(session));
    }

    private static final class Callback
        extends AbstractProxySessionCallback<Object>
    {
        private Callback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}

