package ru.yandex.search.district.indexer;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.district.DistrictEntityType;
import ru.yandex.search.district.DistrictFields;

public class IncrementDistrictHandler implements DistrictIndexHandler {
    private static final Map<DistrictEntityType, List<String>> PRESERVE_FIELDS
        = DistrictFields.preserveFields();

    private final DistrictFields field;
    private final boolean all;

    public IncrementDistrictHandler(final DistrictFields field) {
        this.field = field;
        this.all = field.entityiesTypes().contains(DistrictEntityType.ALL);
    }

    @Override
    public void handle(
        final AbstractIndexContext context,
        final BasicDistrictIndexer indexer)
        throws HttpException, JsonException, IOException
    {
        if (!all && !field.entityiesTypes().contains(context.entityType())) {
            throw new BadRequestException(
                "Unsupported action for entity_type " + context.entityType()
                    + " for field " + field.field()
                    + ' ' + JsonType.HUMAN_READABLE.toString(context.data()));
        }

        StringBuilder uri = context.uri(new StringBuilder("/update?"));

        StringBuilder sb = new StringBuilder();
        JsonWriter writer = JsonType.NORMAL.create(new StringBuilderWriter(sb));
        writer.startObject();
        writer.key("prefix");
        writer.value(context.prefix());
        writer.key("AddIfNotExists");
        writer.value(true);
        writer.key("PreserveFields");
        writer.value(PRESERVE_FIELDS.get(context.entityType()));
        writer.key("docs");
        writer.startArray();
        writer.startObject();
        writer.key(DistrictFields.ID.field());
        writer.value(context.id());
        writer.key(field.field());
        writer.startObject();
        writer.key("inc");
        writer.startArray();
        writer.value(context.value());
        writer.endArray();
        writer.endObject();
        writer.endObject();
        writer.endArray();
        writer.endObject();

        indexer.index(uri, context.shard(), sb);
    }
}
