package ru.yandex.search.district.indexer;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.district.DistrictEntityType;
import ru.yandex.search.district.DistrictFields;

public class UpdateDistrictHandler implements DistrictIndexHandler {
    private static final Map<DistrictEntityType, List<String>> PRESERVE_FIELDS
        = DistrictFields.preserveFields();

    @Override
    public void handle(
        final AbstractIndexContext context,
        final BasicDistrictIndexer indexer)
        throws JsonException, IOException
    {
        StringBuilder uri = context.uri(new StringBuilder("/update?"));

        StringBuilder sb = new StringBuilder();
        JsonWriter writer = JsonType.NORMAL.create(new StringBuilderWriter(sb));
        writer.startObject();
        writer.key("prefix");
        writer.value(context.prefix());
        writer.key("AddIfNotExists");
        writer.value(true);
        writer.key("PreserveFields");
        writer.value(PRESERVE_FIELDS.get(context.entityType()));
        writer.key("docs");
        writer.startArray();
        writer.value(context.data());
        writer.endArray();
        writer.endObject();

        indexer.index(uri, context.shard(), sb);
    }
}
