package ru.yandex.search.district.indexer.config;

import ru.yandex.dispatcher.producer.AbstractProducerConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractDistrictIndexerConfigBuilder
    <T extends AbstractDistrictIndexerConfigBuilder<T>>
     extends AbstractProducerConfigBuilder<T>
     implements DistrictIndexerConfig
{
    private HttpHostConfigBuilder producerConfig;
    private boolean printUpdates;

    protected AbstractDistrictIndexerConfigBuilder(
        final DistrictIndexerConfig config)
    {
        super(config);
        producerConfig(config.producerConfig());
        printUpdates(config.printUpdates());
    }

    protected AbstractDistrictIndexerConfigBuilder(
        final IniConfig config,
        final DistrictIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.producerConfig =
            new HttpHostConfigBuilder(
                config.section("self-producer"),
                defaults.producerConfig());
        this.printUpdates =
            config.getBoolean("print-updates", defaults.printUpdates());
    }

    @Override()
    public HttpHostConfigBuilder producerConfig() {
        return producerConfig;
    }

    public T producerConfig(final HttpHostConfig value) {
        this.producerConfig = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override
    public boolean printUpdates() {
        return printUpdates;
    }

    public T printUpdates(final boolean printUpdates) {
        this.printUpdates = printUpdates;
        return self();
    }
}
