package ru.yandex.search.district.indexer.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class DistrictIndexerConfigBuilder
     extends AbstractDistrictIndexerConfigBuilder<DistrictIndexerConfigBuilder>
{
    public DistrictIndexerConfigBuilder() {
        this(DistrictIndexerConfigDefaults.INSTANCE);
    }

    public DistrictIndexerConfigBuilder(final DistrictIndexerConfig config) {
        super(config);
    }

    public DistrictIndexerConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, DistrictIndexerConfigDefaults.INSTANCE);
    }

    public DistrictIndexerConfigBuilder(
        final IniConfig config,
        final DistrictIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableDistrictIndexerConfig build() throws ConfigException {
        return new ImmutableDistrictIndexerConfig(
            this);
    }

    @Override
    public DistrictIndexerConfigBuilder self() {
        return this;
    }
}
