package ru.yandex.search.district.indexer.config;

import ru.yandex.dispatcher.producer.ImmutableProducerConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableDistrictIndexerConfig
     extends ImmutableProducerConfig
     implements DistrictIndexerConfig
{
    private final ImmutableHttpHostConfig producerConfig;
    private final boolean printUpdates;

    public ImmutableDistrictIndexerConfig(
        final DistrictIndexerConfig config)
        throws ConfigException
    {
        super(config);
        this.producerConfig =
            new ImmutableHttpHostConfig(
                config.producerConfig());
        this.printUpdates = config.printUpdates();
    }

    @Override
    public ImmutableHttpHostConfig producerConfig() {
        return producerConfig;
    }

    @Override
    public boolean printUpdates() {
        return printUpdates;
    }
}
