#!/bin/bash
set -exo pipefail

source district_proxy_config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
GB2=$((GB + GB))
XMX=$(portoctl get self memory_limit_total)
XMX=$((XMX-GB1_5))
XMS=$((XMX / 4))

MEM_ARGS="-Xms${XMS} -Xmx${XMX}  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=district_search_proxy \
    -DDISTRICT_QUEUE=$DISTRICT_QUEUE \
    -DDISTRICT_CITY_QUEUE=$DISTRICT_CITY_QUEUE \
    -cp $CLASSPATH \
    ru.yandex.search.district.DistrictSearchProxy \
    district_search_proxy.conf