package ru.yandex.search.district;

import java.util.Collection;

import ru.yandex.search.district.search.SearchScope;

public abstract class AbstractDistrictSearchRule {
    protected static final String OR = " OR ";
    protected static final String AND = " AND ";

    // CSOFF: ParameterNumber
    protected void addFilter(
        final StringBuilder sb,
        final DistrictFields field,
        final SearchScope scope,
        final String value)
    {
        if (sb.length() > 0) {
            sb.append(AND);
        }
        sb.append(fieldByScope(field, scope));
        sb.append(':');
        sb.append(value);
    }

    protected void addFilter(
        final StringBuilder sb,
        final DistrictFields field,
        final SearchScope scope,
        final Collection<?> values,
        final String operator)
    {
        if (sb.length() > 0) {
            sb.append(AND);
        }
        sb.append(fieldByScope(field, scope));
        sb.append(':');
        sb.append('(');
        for (Object value: values) {
            sb.append(value);
            sb.append(operator);
        }
        sb.setLength(sb.length() - operator.length());
        sb.append(')');
    }
    // CSON: ParameterNumber

    protected static String fieldByScope(
        final DistrictFields field,
        final SearchScope scope)
    {
        if (scope == SearchScope.DISTRICTS) {
            return field.prefixedField();
        } else {
            return field.prefixedField();
        }
    }
}
