package ru.yandex.search.district.config;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractDistrictSearchProxyConfigBuilder
    <T extends AbstractDistrictSearchProxyConfigBuilder<T>>
     extends AbstractUniversalSearchProxyConfigBuilder<T>
     implements DistrictSearchProxyConfig
{
    private long searchFailOverDelay;
    private HttpTargetConfigBuilder wizardSearchClientConfig;

    protected AbstractDistrictSearchProxyConfigBuilder(
        final DistrictSearchProxyConfig config)
    {
        super(config);

        searchFailOverDelay(config.searchFailOverDelay());
        wizardSearchClientConfig(config.wizardSearchClientConfig());
    }

    protected AbstractDistrictSearchProxyConfigBuilder(
        final IniConfig config,
        final DistrictSearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.searchFailOverDelay =
            config.getLong(
                "search-fail-over-delay",
                defaults.searchFailOverDelay());
        this.wizardSearchClientConfig =
            new HttpTargetConfigBuilder(
                config.section("wizard"),
                defaults.wizardSearchClientConfig());
    }

    @Override()
    public long searchFailOverDelay() {
        return searchFailOverDelay;
    }

    public T searchFailOverDelay(final long value) {
        this.searchFailOverDelay = value;
        return self();
    }

    @Override()
    public HttpTargetConfigBuilder wizardSearchClientConfig() {
        return wizardSearchClientConfig;
    }

    public T wizardSearchClientConfig(final HttpTargetConfig value) {
        this.wizardSearchClientConfig =
            new HttpTargetConfigBuilder(value);

        return self();
    }
}
