package ru.yandex.search.district.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class DistrictSearchProxyConfigBuilder
     extends AbstractDistrictSearchProxyConfigBuilder<
    DistrictSearchProxyConfigBuilder>
{
    public DistrictSearchProxyConfigBuilder() {
        this(DistrictSearchProxyConfigDefaults.INSTANCE);
    }

    public DistrictSearchProxyConfigBuilder(
        final DistrictSearchProxyConfig config)
    {
        super(config);
    }

    public DistrictSearchProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, DistrictSearchProxyConfigDefaults.INSTANCE);
    }

    public DistrictSearchProxyConfigBuilder(
        final IniConfig config,
        final DistrictSearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableDistrictSearchProxyConfig build() throws ConfigException {
        return new ImmutableDistrictSearchProxyConfig(this);
    }

    @Override
    public DistrictSearchProxyConfigBuilder self() {
        return this;
    }
}
