package ru.yandex.search.district.config;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableDistrictSearchProxyConfig
     extends ImmutableUniversalSearchProxyConfig
     implements DistrictSearchProxyConfig
{
    private final long searchFailOverDelay;
    private final ImmutableHttpTargetConfig wizardSearchClientConfig;

    public ImmutableDistrictSearchProxyConfig(
        final DistrictSearchProxyConfig config)
        throws ConfigException
    {
        super(config);
        this.searchFailOverDelay = config.searchFailOverDelay();
        this.wizardSearchClientConfig =
            new ImmutableHttpTargetConfig(
                config.wizardSearchClientConfig());
    }

    @Override
    public long searchFailOverDelay() {
        return searchFailOverDelay;
    }

    @Override
    public ImmutableHttpTargetConfig wizardSearchClientConfig() {
        return wizardSearchClientConfig;
    }
}
