package ru.yandex.search.district.search;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class DistrictSearchConcatResultsRule<T extends RequestsProvider, U>
    implements SearchRule<T, DistrictSearchResult>
{
    private final ChainedSearchRule<T, U, String, DistrictSearchResult> next;

    public DistrictSearchConcatResultsRule(
        final ChainedSearchRule<T, U, String, DistrictSearchResult> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super DistrictSearchResult> callback)
        throws HttpException
    {
        List<String> requests = input.requests();
        MultiFutureCallback<DistrictSearchResult> multiCallback =
            new MultiFutureCallback<>(new Callback<>(callback));
        for (String request: requests) {
            next.execute(input, request, multiCallback.newCallback());
        }
        multiCallback.done();
    }

    private static class Callback<R>
        extends AbstractFilterFutureCallback<List<DistrictSearchResult>,
        DistrictSearchResult>
    {
        Callback(final FutureCallback<? super DistrictSearchResult> callback) {
            super(callback);
        }

        @Override
        public void completed(final List<DistrictSearchResult> results) {
            DistrictSearchResult allResults = new DistrictSearchResult();
            for (DistrictSearchResult result: results) {
                allResults.addAll(result.totalResults(), result.items());
            }
            callback.completed(allResults);
        }
    }
}

