package ru.yandex.search.district.search;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.search.district.DistrictSearchProxy;
import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.TranslitRule;

public class DistrictSearchHandler implements ProxyRequestHandler {
    private final SearchRule<BasicDistrictSearchContext,
        DistrictSearchResult> rule;

    private final DistrictSearchProxy proxy;

    public DistrictSearchHandler(final DistrictSearchProxy proxy) {
        this.proxy = proxy;
        this.rule = new TranslitRule<>(
            new ChainedSearchRule<>(
                new DistrictSearchConcatResultsRule<>(
                    new ChainedSearchRule<>(
                        new DistrictSearchRule<>(proxy),
                        (input, request) ->
                            new DistrictSearchRequestContextProvider(
                                input.searchContext(),
                                request))),
                (input, requests) ->
                    new DistrictSearchRequestsContextProvider(
                        input.searchContext(),
                        requests)),
            true);
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        BasicDistrictSearchContext context =
            new BasicDistrictSearchContext(proxy, session);

        rule.execute(context, new DistrictSearchResultPrinter(context));
    }
}
